#version 330
#extension GL_EXT_gpu_shader4 : enable
// Chaotic SymmetryMod01.fsh  by  Passion

//https://www.shadertoy.com/view/Xdy3RK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/* 2016 Passion */

//Random function
float rand(vec2 n) { 
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

//Noise function
float noise(vec2 n) {
    const vec2 d = vec2(0.0, 1.0);
    vec2 b = floor(n), f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
    return mix(mix(rand(b), rand(b + d.yx), f.x), mix(rand(b + d.xy), rand(b + d.yy), f.x), f.y);
}

//Fbm function
float fbm(vec2 n) {
    float total = 0.0, amplitude = 1.0;
    //n.x+=iTime;
    for (int i = 0; i < 5; i++) {
        total += noise(n) * amplitude;
        n += n;
        amplitude *= 0.5;
    }
    return total;
}

//2D Rotation
mat2 rot(float deg){    
    return mat2(cos(deg),-sin(deg),
                sin(deg), cos(deg));
        
}
//Main
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord)
{
    
    //Center uv coordinates
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    float vinette = 1.-pow(length(uv*uv*uv*uv)*1.01,10.);
    uv.x *= iResolution.x / iResolution.y;
   
    //uv+=noise(.2*uv-iTime);
    float t = iTime*.75;
    
    const int numIter = 5;
    
    //The Fractal
    for(int i = 0; i<numIter; i++){
        
        uv*=rot(t*.16);
        uv = abs(uv) / dot(uv,uv);
        uv.x = abs(uv.x+cos(t*.6)*.5);
        uv.x = abs(uv.x-.8);
        uv = abs(rot(-t*.3)*uv);
        uv.y = abs(uv.y-.5);
        uv.y = abs(uv.y+.03+sin(t)*.25);
        
    }
    
    uv = abs(uv) / float(numIter);

    vec3 c1 = vec3(noise(uv*7.),
                   sin(fbm(uv*.6)), 
                   cos(fbm(uv*8.)));
    
    uv+=abs(.1*t+uv*2.23);
    
    vec3 c2 = vec3(cos(fbm(uv*8.+noise(uv*5.5))), 
                   cos(fbm(7.*uv)), 
                   cos(uv*6. - fbm(5.*uv)));
    //Mix and gama adjustments
    gl_FragColor = vec4(pow(mix( c1, c2, (noise(2.*uv))), vec3(1.0/0.5)) ,1.0)*vinette;
}